program ProstyPrzykład;

uses
  RTTI, System.SysUtils, TypInfo, System.Classes;

type
  Etykieta = class(TCustomAttribute)
  private
    FEtykieta: string;
  public
    constructor Create(aEtykieta: string);
    property PokażEtykietę: string read FEtykieta write FEtykieta;
  end;

constructor Etykieta.Create(aEtykieta: string);
begin
  FEtykieta := aEtykieta;
end;

type
  TKlient = class(TObject)
  private
    FImię: string;
    FNazwisko: string;
    FAdres: string;
    FKodPocztowy: string;
    FMiasto: string;
    FWojewództwo: string;
    FTelefon: string;
  public
    [Etykieta('Imię')]
    property Imię: string read FImię write FImię;
    [Etykieta('Nazwisko')]
    property Nazwisko: string read FNazwisko write FNazwisko;
    [Etykieta('Adres zamieszkania')]
    property Adres: string read FAdres write FAdres;
    [Etykieta('Miejscowość')]
    property Miasto: string read FMiasto write FMiasto;
    [Etykieta('Województwo')]
    property Województwo: string read FWojewództwo write FWojewództwo;
    [Etykieta('Kod pocztowy')]
    property KodPocztowy: string read FKodPocztowy write FKodPocztowy;
    [Etykieta('Nr telefonu')]
    property Telefon: string read FTelefon write FTelefon;
  end;

procedure PobierzWszystkieEtykietyKlasy(aKlasa: TClass; const aListaTekstów: TStrings);

  function PobierzEtykietęWłaściwości(aWłaściwość: TRTTIProperty; aNazwaWłaściwości: string): string;
  var
    TymczAtrybut: TCustomAttribute;
  begin
    Result := '';
    if aWłaściwość <> nil then
    begin
      for TymczAtrybut in aWłaściwość.GetAttributes do
      begin
        if TymczAtrybut is Etykieta then
        begin
          Result := Etykieta(TymczAtrybut).PokażEtykietę;
        end;
      end;
    end;
  end;

var
  Kontekst: TRttiContext;
  TymczWłaściwość: TRTTIProperty;
  TymczTyp: TRttiType;
  TymczNazwa, TymczWartość: string;
begin
  if aListaTekstów = nil then
    Exit;
  aListaTekstów.Clear;
  Kontekst := TRttiContext.Create;
  try
    TymczTyp := Kontekst.GetType(aKlasa);
    for TymczWłaściwość in TymczTyp.GetProperties do
    begin
      TymczNazwa := TymczWłaściwość.Name;
      TymczWartość := PobierzEtykietęWłaściwości(TymczWłaściwość, TymczNazwa);
      aListaTekstów.Values[TymczNazwa] := TymczWartość;
    end;
  finally
    Kontekst.Free;
  end;
end;

var
  ListaAtrybutów: TStringList;
  i: integer;
begin
  ListaAtrybutów := TStringList.Create;
  PobierzWszystkieEtykietyKlasy(TKlient, ListaAtrybutów);
  for i := 0 to ListaAtrybutów.Count - 1 do
    WriteLn('Właściwość ', ListaAtrybutów.Names[i], ', wartość: ', ListaAtrybutów.ValueFromIndex[i]);
  ListaAtrybutów.Free;
  ReadLn;
end.